/*
    Copyright (c) 2002, bDistributed.com, Inc.
    All rights reserved.

    Redistribution and use in source and binary forms, with or
    without modification, are permitted provided that the following
    conditions are met:

    *   Redistributions of source code must retain the above
        copyright notice, this list of conditions and the following
        disclaimer.
    
    *   Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials
        provided with the distribution.
    
    *   Neither the name of bDistributed.com, Inc. nor the names of
        its contributors may be used to endorse or promote products
        derived from this software without specific prior written
        permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
    CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
    OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
    OF SUCH DAMAGE.
*/

#ifndef __BDQualifierNode__
#define __BDQualifierNode__ 1

#include <stdio.h>
#include "BDStringNode.h"

enum BDQualifierNodeType {
    kBDInvalidQualifierNodeType = 0,
    kBDAndQualifierNodeType = 1,
    kBDOrQualifierNodeType = 2,
    kBDNotQualifierNodeType = 3,
    kBDKeyValueQualifierNodeType = 4,
    kBDKeyComparisonQualifierNodeType = 5,
    kBDBooleanQualifierNodeType = 6
};

enum BDQualifierNodeValueType {
    kBDQualifierNodeValueNumber = 1,
    kBDQualifierNodeValueString = 2,
    kBDQualifierNodeValueNil = 3,
    kBDQualifierNodeValueTypedString = 4,
    kBDQualifierNodeValueVariable = 5,
    kBDQualifierNodeValueBoolean = 6
};

union BDQualifierNodeValueData {
    double doubleValue;
    char *stringValue;
    char *typedStringType;
    char *typedStringValue;
    char *variableValue;
    int booleanValue;
};

struct BDQualifierNode; /* forward declaration */

struct BDAndQualifierNode {
    struct BDQualifierNode *leftQual;
    struct BDQualifierNode *rightQual;
};

struct BDOrQualifierNode {
    struct BDQualifierNode *leftQual;
    struct BDQualifierNode *rightQual;
};

struct BDNotQualifierNode {
    struct BDQualifierNode *qual;
};

struct BDKeyValueQualifierNode {
    char *key;
    char *operatorSelector;
    enum BDQualifierNodeValueType valueType;
    union BDQualifierNodeValueData valueData;
};

struct BDKeyComparisonQualifierNode {
    char *leftKey;
    char *operatorSelector;
    char *rightKey;
};

union BDQualifierNodeData {
    struct BDAndQualifierNode andNode;
    struct BDOrQualifierNode orNode;
    struct BDNotQualifierNode notNode;
    struct BDKeyValueQualifierNode keyValueNode;
    struct BDKeyComparisonQualifierNode keyComparisonNode;
    int booleanNode;
};

struct BDQualifierNode {
    int rc;
    enum BDQualifierNodeType type;
    union BDQualifierNodeData data;
};

typedef struct BDQualifierNode BDQualifierNode;

BDQualifierNode *BDQualifierNodeCreateAndNode(BDQualifierNode *left,
                                              BDQualifierNode *right);

BDQualifierNode *BDQualifierNodeCreateOrNode(BDQualifierNode *left,
                                             BDQualifierNode *right);

BDQualifierNode *BDQualifierNodeCreateNotNode(BDQualifierNode *qual);

BDQualifierNode *BDQualifierNodeCreateKeyValueNode(BDStringNode *key,
                                                   BDStringNode *operatorSelector,
                                                   enum BDQualifierNodeValueType valueType,
                                                   double doubleValue,
                                                   BDStringNode *stringValue,
                                                   BDStringNode *typedStringType,
                                                   BDStringNode *typedStringValue,
                                                   BDStringNode *variableValue,
                                                   int booleanValue);

BDQualifierNode *BDQualifierNodeCreateKeyComparisonNode(BDStringNode *leftKey,
                                                        BDStringNode *operatorSelector,
                                                        BDStringNode *rightKey);

BDQualifierNode *BDQualifierNodeCreateBooleanNode(int value);

BDQualifierNode *BDQualifierNodeRetain(BDQualifierNode *node);
void BDQualifierNodeRelease(BDQualifierNode *node);

void BDQualifierNodeDump(BDQualifierNode *node, FILE *file);

#endif /* __BDQualifierNode__ */
